package jp.kawakubo;

import java.io.IOException;
import java.util.List;
import java.util.ArrayList;
import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasketServlet extends HttpServlet {

    @EJB
    private JPASession01Remote jpaBean;
   
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {

        List<BasketItemContent> basketItemContents = new ArrayList<BasketItemContent>();

        String[] meigaraItems = request.getParameterValues("items");
        int [] meigaraIds = new int[meigaraItems.length];
        for (int i = 0; i < meigaraItems.length; i++) {
            meigaraIds[i] = Integer.parseInt(meigaraItems[i]);
        }

        jpaBean.insertBasketItems(meigaraIds);

        basketItemContents = jpaBean.getBasketItems("");
        request.getSession().setAttribute("basket", basketItemContents);

        List totalCharge = jpaBean.getTotalCharge(basketItemContents);
        request.getSession().setAttribute("totalCharge", totalCharge);

        // ImoshochuShop.jspに遷移する
        RequestDispatcher rd = request.getRequestDispatcher("/ImoshochuShop.jsp");
        rd.forward(request, response);
    } 

    // <editor-fold defaultstate="collapsed" desc="HttpServlet のメソッドです。コードを編集するには、左側の + 符号をクリックしてください。">
    /** 
     * Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {

        processRequest(request, response);

    } 

    /** 
     * Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {

        processRequest(request, response);

    }

    /** 
     * Returns a short description of the servlet.
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "Short description";
    }// </editor-fold>

}
